%%%%%%%%%%%%%%%%%%%
% Fit yearly data %
%%%%%%%%%%%%%%%%%%%
warning off all

cdx_tv_yearly = subperiod_cdx2(CDX_NA_IG2, [datenum('09/21/2004'); datenum('12/01/2005'); datenum('11/01/2006')]);
cdx_tv_yearly = initialize_parameters_cdx(cdx_tv_yearly, discounts_IMM, 101);
cdx_tv_yearly = fit_model_cds_portfolio(cdx_tv_yearly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1]);

profile on
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_tv_yearly, cdx_tv_yearly.dates{1}), cdx_tv_yearly, discounts_IMM, ...
                                           datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
profile viewer;

[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_tv_yearly, cdx_tv_yearly.dates{1}), cdx_tv_yearly, discounts_IMM, ...
                                           datenum('09/21/2004'), datenum('09/21/2004'), 2^17, [1 0 0 1], [1 0 0], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);

cdx_tv_yearly = fit_liq_prem_cds3(cdx_tv_yearly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], ...
                                  124, 0, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_tv_yearly = fit_liq_prem_tranches2(cdx_tv_yearly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], ...
                                      124, 0, 'mu*L', 'thet*k', CDX_NA_IG);

cdx_tv_yearly = update_model_y0_v2(cdx_tv_yearly, discounts_IMM, 2^17, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1], [1 0 0], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_tv_yearly = iterative_fitting(cdx_tv_yearly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1], [1 0 0], 2^17, 1, 121, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);

% Store fitted parameters
save_fitted_model(cdx_tv_yearly, 'tv_yearly', datenum('09/21/2004'), datenum('11/01/2006'))
test2 = subperiod_cdx2(CDX_NA_IG2, [datenum('09/21/2004'); datenum('12/01/2005'); datenum('11/01/2006')]);
test2 = load_fitted_model(test2, 'tv_yearly');
[trash, test3] = wrapper_tranche_mispricing(get_x0(test2, test2.dates{1}), test2, discounts_IMM, ...
                                           datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 0], [1 0 0], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);

% Just one date 
[trash, test2] = wrapper_tranche_mispricing(get_x0(cdx_tv_yearly, datenum('12/01/2005')), cdx_tv_yearly, discounts_IMM, ...
                                            datenum('12/01/2005'), datenum('12/01/2005'), 2^17, [1 0 0 1], [1 0 0], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_tv_yearly = fit_model_cdx_xi4(1, cdx_tv_yearly, discounts_IMM, datenum('12/01/2005'), datenum('12/01/2005'), 2^17, [1 0 0 1],[1 0 0], 121, 0, 2, 2, 'mu*L', 'thet*k', CDX_NA_IG);
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit yearly data - all horizons %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

cdx_tv_yearly10 = cdx_tv_yearly;

profile on
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_tv_yearly10, cdx_tv_yearly10.dates{1}, 'mu*L', 'thet*k'), cdx_tv_yearly10, ...
                                           discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 1 1 0], [1 1 1], ...
                                           124, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
profile viewer;

cdx_tv_yearly10 = fit_liq_prem_cds3(cdx_tv_yearly10, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 1 1 0], [1 1 1], 124, 0, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_tv_yearly10 = fit_liq_prem_tranches2(cdx_tv_yearly10, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 1 1 0], [1 1 1], 124, 0, 'mu*L', 'thet*k', CDX_NA_IG);

tic;
cdx_tv_yearly10 = iterative_fitting(cdx_tv_yearly10, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), [1 1 1 0], [1 1 1], ...
                                    2^17, 2, 124, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);                                  
toc; 

for i=1:length(cdx_tv_yearly10.portfolio)
    cdx_tv_yearly10.portfolio(i).AJD.theta = max(0, cdx_tv_yearly10.portfolio(i).AJD.theta);
    cdx_tv_yearly10.portfolio(i).AJD.L = max(0, cdx_tv_yearly10.portfolio(i).AJD.L);
    cdx_tv_yearly10.portfolio(i).AJD.mu = max(0, cdx_tv_yearly10.portfolio(i).AJD.mu);
end

% Store fitted parameters
save_fitted_model(cdx_tv_yearly10, 'tv_yearly10', datenum('09/21/2004'), datenum('11/01/2006'))                                       
cdx_tv_yearly10 = load_fitted_model(cdx_tv_yearly10, 'tv_yearly10');

%%%%%%%%%%%%%%%%%%%%%%
% Fit quarterly data %
%%%%%%%%%%%%%%%%%%%%%%

cdx_tv_quarterly = subperiod_cdx2(CDX_NA_IG2, [datenum('09/21/2004'); datenum('01/04/2005'); datenum('04/01/2005'); datenum('07/01/2005'); ...
                                               datenum('10/03/2005'); datenum('01/03/2006'); datenum('04/03/2006'); datenum('07/03/2006'); ...
                                               datenum('11/01/2006')]);
cdx_tv_quarterly = initialize_parameters_cdx(cdx_tv_quarterly, discounts_IMM, 102);
cdx_tv_quarterly = CDX_interpolate_parameters(cdx_tv_quarterly, cdx_tv_yearly);

profile on;
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_tv_quarterly, cdx_tv_quarterly.dates{1}), cdx_tv_quarterly, discounts_IMM, ...
                                           datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
profile viewer;

cdx_tv_quarterly = fit_liq_prem_cds3(cdx_tv_quarterly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], 121, 0, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_tv_quarterly = fit_liq_prem_tranches2(cdx_tv_quarterly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], 121, 0, 'mu*L', 'thet*k', CDX_NA_IG);

cdx_tv_quarterly = update_model_y0_v2(cdx_tv_quarterly, discounts_IMM, 2^17, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1], [1 0 0], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
tic;
cdx_tv_quarterly = iterative_fitting(cdx_tv_quarterly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1], [1 0 0], 2^17, 6, 121, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
toc;

% Just one date
tic;
cdx_tv_quarterly = iterative_fitting(cdx_tv_quarterly, discounts_IMM, datenum('01/04/2005'), datenum('01/04/2005'), [1 0 0 1], [1 0 0], 2^17, 1, 121, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
toc;
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_tv_quarterly, datenum('01/04/2005'), 'mu*L', 'thet*k'), cdx_tv_quarterly, discounts_IMM, ...
                                            datenum('01/04/2005'), datenum('01/04/2005'), 2^17, [1 0 0 1], [1 0 0], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
                                        
cdx_tv_quarterly = iterative_fitting(cdx_tv_quarterly, discounts_IMM, datenum('01/04/2005'), datenum('01/04/2005'), [1 0 0 1], [1 0 0], 2^17, 1, 121, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
                                                                            
% Store fitted parameters
save_fitted_model(cdx_tv_quarterly, 'tv_quarterly', datenum('09/21/2004'), datenum('11/01/2006'))                                       
cdx_tv_quarterly = subperiod_cdx2(CDX_NA_IG2, [datenum('09/21/2004'); datenum('01/04/2005'); datenum('04/01/2005'); datenum('07/01/2005'); ...
                                               datenum('10/03/2005'); datenum('01/03/2006'); datenum('04/03/2006'); datenum('07/03/2006'); ...
                                               datenum('11/01/2006')]);
cdx_tv_quarterly = load_fitted_model(cdx_tv_quarterly, 'tv_quarterly');
                                       
%%%%%%%%%%%%%%%%%%%%
% Fit monthly data %
%%%%%%%%%%%%%%%%%%%%                                       
cdx_tv_monthly = subperiod_cdx2(CDX_NA_IG2, [datenum('09/21/2004'); datenum('11/02/2004'); datenum('12/001/2004'); datenum('01/04/2005'); ...
                                             datenum('01/04/2005'); datenum('02/01/2005'); datenum('03/01/2005'); datenum('04/01/2005'); ...
                                             datenum('05/02/2005'); datenum('06/01/2005'); datenum('07/01/2005'); datenum('08/01/2005'); ...
                                             datenum('09/01/2005'); datenum('10/03/2005'); datenum('11/01/2005'); datenum('12/01/2005'); ...
                                             datenum('01/03/2006'); datenum('02/01/2006'); datenum('03/01/2006'); datenum('04/03/2006'); ...
                                             datenum('05/01/2006'); datenum('06/01/2006'); datenum('07/03/2006'); datenum('08/01/2006'); ...
                                             datenum('09/01/2006'); datenum('10/02/2006'); datenum('11/01/2006');]);
cdx_tv_monthly = initialize_parameters_cdx(cdx_tv_monthly, discounts_IMM, 102);
cdx_tv_monthly = CDX_interpolate_parameters(cdx_tv_monthly, cdx_tv_quarterly);

profile on
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_tv_monthly, cdx_tv_monthly.dates{1}, 'mu*L', 'thet*k'), cdx_tv_monthly, discounts_IMM, ...
                                           datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], 124, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
profile viewer;                                       

cdx_tv_monthly = fit_liq_prem_cds3(cdx_tv_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], 124, 0, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_tv_monthly = fit_liq_prem_tranches2(cdx_tv_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], 124, 0, 'mu*L', 'thet*k', CDX_NA_IG);

cdx_tv_monthly = update_model_y0_v2(cdx_tv_monthly, discounts_IMM, 2^17, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1], [1 0 0], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
tic;
cdx_tv_monthly = iterative_fitting(cdx_tv_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1], [1 0 0], 2^17, 2, 124, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);                                  
toc;         

% Store fitted parameters
save_fitted_model(cdx_tv_monthly, 'tv_monthly', datenum('09/21/2004'), datenum('11/01/2006'))                                       
cdx_tv_monthly = load_fitted_model(cdx_tv_monthly, 'tv_monthly');

% Just one date
tic;
cdx_tv_monthly = iterative_fitting(cdx_tv_monthly, discounts_IMM, datenum('12/01/2005'), datenum('12/01/2005'), [1 0 0 1], [1 0 0], 2^17, 1, 124, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
toc;
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_tv_monthly, datenum('12/01/2005'), 'mu*L', 'thet*k'), cdx_tv_monthly, discounts_IMM, ...
                                            datenum('12/01/2005'), datenum('12/01/2005'), 2^17, [1 0 0 1], [1 0 0], 124, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
                                        
cdx_tv_quarterly = iterative_fitting(cdx_tv_quarterly, discounts_IMM, datenum('01/04/2005'), datenum('01/04/2005'), [1 0 0 1], [1 0 0], 2^17, 1, 124, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
cdx_tv_monthly = update_model_y0_v2(cdx_tv_monthly, discounts_IMM, 2^17, datenum('01/04/2005'), datenum('01/04/2005'), [1 0 0 1], [1 0 0], 124, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);              


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit monthly data - all horizons %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

cdx_tv_monthly10 = subperiod_cdx2(CDX_NA_IG2, [datenum('09/21/2004'); datenum('11/02/2004'); datenum('12/001/2004'); datenum('01/04/2005'); ...
                                             datenum('01/04/2005'); datenum('02/01/2005'); datenum('03/01/2005'); datenum('04/01/2005'); ...
                                             datenum('05/02/2005'); datenum('06/01/2005'); datenum('07/01/2005'); datenum('08/01/2005'); ...
                                             datenum('09/01/2005'); datenum('10/03/2005'); datenum('11/01/2005'); datenum('12/01/2005'); ...
                                             datenum('01/03/2006'); datenum('02/01/2006'); datenum('03/01/2006'); datenum('04/03/2006'); ...
                                             datenum('05/01/2006'); datenum('06/01/2006'); datenum('07/03/2006'); datenum('08/01/2006'); ...
                                             datenum('09/01/2006'); datenum('10/02/2006'); datenum('11/01/2006');]);
cdx_tv_monthly10 = cdx_tv_monthly;

profile on
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_tv_monthly10, cdx_tv_monthly10.dates{1}, 'mu*L', 'thet*k'), cdx_tv_monthly10, ...
                                           discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 1 1 0], [1 1 1], ...
                                           124, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
profile viewer;

cdx_tv_monthly10 = fit_liq_prem_cds3(cdx_tv_monthly10, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 1 1 0], [1 1 1], 124, 0, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_tv_monthly10 = fit_liq_prem_tranches2(cdx_tv_monthly10, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 1 1 0], [1 1 1], 124, 0, 'mu*L', 'thet*k', CDX_NA_IG);

tic;
cdx_tv_monthly10 = iterative_fitting(cdx_tv_monthly10, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), [1 1 1 0], [1 1 1], ...
                                        2^17, 10, 124, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);                                  
toc; 

% Store fitted parameters
save_fitted_model(cdx_tv_monthly10, 'tv_monthly10', datenum('09/21/2004'), datenum('11/01/2006'))                                       
cdx_tv_monthly10 = load_fitted_model(cdx_tv_monthly10, 'tv_monthly10');

% Just one date
profile on
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_tv_monthly10, datenum('03/01/2006'), 'mu*L', 'thet*k'), cdx_tv_monthly10, ...
                                           discounts_IMM, datenum('03/01/2006'), datenum('03/01/2006'), 2^17, [1 1 1 0], [1 1 1], ...
                                           124, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
profile viewer;
                                       
tic;
cdx_tv_monthly10 = iterative_fitting(cdx_tv_monthly10, discounts_IMM, datenum('03/01/2006'), datenum('03/01/2006'), [1 1 1 0], [1 1 1], ...
                                        2^17, 8, 124, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);                                  
toc; 

%%%%%%%%%%%%%%%%%%%%%%%
% Test - all horizons %
%%%%%%%%%%%%%%%%%%%%%%%

test10 = subperiod_cdx2(CDX_NA_IG2, [datenum('09/21/2004'); datenum('11/02/2004'); datenum('12/001/2004'); datenum('01/04/2005'); ...
                                             datenum('01/04/2005'); datenum('02/01/2005'); datenum('03/01/2005'); datenum('04/01/2005'); ...
                                             datenum('05/02/2005'); datenum('06/01/2005'); datenum('07/01/2005'); datenum('08/01/2005'); ...
                                             datenum('09/01/2005'); datenum('10/03/2005'); datenum('11/01/2005'); datenum('12/01/2005'); ...
                                             datenum('12/05/2005'); ...
                                             datenum('01/03/2006'); datenum('02/01/2006'); datenum('03/01/2006'); datenum('04/03/2006'); ...
                                             datenum('05/01/2006'); datenum('06/01/2006'); datenum('07/03/2006'); datenum('08/01/2006'); ...
                                             datenum('09/01/2006'); datenum('10/02/2006'); datenum('11/01/2006');]);

test10 = CDX_interpolate_parameters(test10, cdx_tv_monthly10);
if (0)
    % Copy cdx_mor10 parameters into test10
    test10 = CDX_copy_parameters(test10, cdx_mor10, cdx_mor10.dates{1});    
    
    % Text index price calculation
    test = update_model_price_index(test10, discounts_IMM, [1 1 1], datenum('12/05/2005'), datenum('12/05/2005'));
    cdx_mor10 = update_model_price_index(cdx_mor10, discounts_IMM, [1 1 1], datenum('12/05/2005'), datenum('12/05/2005'));    
    test11 = subperiod_cdx(test10, datenum('12/05/2005'), datenum('12/05/2005'));
    test12 = update_model_price_index(test11, discounts_IMM, [1 1 1], datenum('12/05/2005'), datenum('12/05/2005'));
    
    % Test cds price calculation
    test = fit_model_cds_portfolio(test10, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 1 1 0]);
    
    % Test tranche price calculation
    test = update_model_price_tranches(test10, discounts_IMM, 2^18, datenum('12/05/2005'), datenum('12/05/2005'), [1 1 1], 0, 2);
    test2 = update_model_price_tranches(cdx_mor10, discounts_IMM, 2^18, datenum('12/05/2005'), datenum('12/05/2005'), [1 1 1], 0, 2);
end
test10.LGD = cdx_tv_monthly10.LGD;

profile on
[trash, test] = wrapper_tranche_mispricing(get_x0(test10, test10.dates{1}, 'mu*L', 'thet*k'), test10, ...
                                           discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 1 1 0], [1 1 1], ...
                                           124, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
profile viewer;
test = update_model_price_tranches(test10, discounts_IMM, 2^17, datenum('09/21/2004'), datenum('11/01/2006'), [1 1 1 0], 0, 2);
    
% Just one date
[trash, test] = wrapper_tranche_mispricing(get_x0(test10, datenum('12/05/2005'), 'mu*L', 'thet*k'), test10, ...
                                           discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^17, [1 1 1 0], [1 1 1], ...
                                           124, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
test = update_model_price_tranches(test10, discounts_IMM, 2^17, datenum('12/05/2005'), datenum('12/05/2005'), [1 1 1 0], 0, 2);
                                       
tic;
test10 = iterative_fitting(test10, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 1 1 0], [1 1 1], ...
                           2^18, 10, 124, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);                                  
toc; 

% Store fitted parameters
save_fitted_model(test10, 'test10', datenum('09/21/2004'), datenum('11/01/2006'))                                       
test10 = load_fitted_model(test10, 'test10');

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit monthly data - LGD1 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%
cdx_tv_monthly_lgd1 = cdx_tv_monthly;
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_tv_monthly_lgd1, cdx_tv_monthly_lgd1.dates{1}, 'mu*L', 'thet*k'), cdx_tv_monthly, ...
                                           discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], ...
                                           124, 1, 2, 'mu*L', 'thet*k', CDX_NA_IG);
                                       
cdx_tv_monthly_lgd1 = fit_liq_prem_cds3(cdx_tv_monthly_lgd1, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], 124, 1, 'mu*L', 'thet*k', CDX_NA_IG);                                       
cdx_tv_monthly_lgd1 = fit_liq_prem_tranches2(cdx_tv_monthly_lgd1, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], 124, 1, 'mu*L', 'thet*k', CDX_NA_IG);

tic;
cdx_tv_monthly_lgd1 = iterative_fitting(cdx_tv_monthly_lgd1, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1], [1 0 0], ...
                                        2^17, 1, 124, 1, 0, 'mu*L', 'thet*k', CDX_NA_IG);                                  
toc; 

% Store fitted parameters
save_fitted_model(cdx_tv_monthly_lgd1, 'tv_monthly_lgd1', datenum('09/21/2004'), datenum('11/01/2006'))                                       
cdx_tv_monthly_lgd1 = load_fitted_model(cdx_tv_monthly_lgd1, 'tv_monthly_lgd1');


%%%%%%%%%%%%%%%%%%%
% Fit weekly data %
%%%%%%%%%%%%%%%%%%%
start_pos = find(CDX_NA_IG2.dates{1}==datenum('09/21/2004'));
used_dates = get_dates_month_evenly(CDX_NA_IG2.dates{1}(start_pos:end,:), 2);
cdx_tv_weekly = subperiod_cdx2(CDX_NA_IG2, used_dates);
cdx_tv_weekly = initialize_parameters_cdx(cdx_tv_weekly, discounts_IMM, 102);
cdx_tv_weekly = CDX_interpolate_parameters(cdx_tv_weekly, cdx_tv_monthly);     

profile on
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_tv_weekly, cdx_tv_weekly.dates{1}, 'mu*L', 'thet*k'), cdx_tv_weekly, ...
                                           discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], ...
                                           124, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
profile viewer                                       

cdx_tv_weekly = fit_liq_prem_cds3(cdx_tv_weekly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], 124, 0, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_tv_weekly = fit_liq_prem_tranches2(cdx_tv_weekly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^17, [1 0 0 1], [1 0 0], 124, 0, 'mu*L', 'thet*k', CDX_NA_IG);


tic;
cdx_tv_weekly = iterative_fitting(cdx_tv_weekly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1], [1 0 0], 2^17, 2, 124, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);                                  
toc;  

% Store fitted parameters
save_fitted_model(cdx_tv_weekly, 'tv_weekly', datenum('09/21/2004'), datenum('11/01/2006'))                                       
cdx_tv_weekly = load_fitted_model(cdx_tv_weekly, 'tv_weekly');

% for i=1:length(CDX_NA_IG2.portfolio)
%     if (length(CDX_NA_IG2.portfolio(i).dates{1}) - length(unique(CDX_NA_IG2.portfolio(i).dates{1})) > 0)
%         disp(i);
%     end
% end



                                         