%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Historical (model-free plots) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Plot notional amount of outstanding CDS contracts (need to import data manually first from
% c:/thesis/data/cds notional outstanding.txt'
visualize_cds_notional(cdsNotionalOutstanding, rowheaders, 2);

% Plot CDS spread history for Alcoa., ABS, GM, ...
plot_cds_history(CDX_NA_IG2, 'AA');
plot_cds_history(CDX_NA_IG2, 'ABS');
plot_cds_history(CDX_NA_IG2, 'GM');

% Make a nice plot of CDX.NA.IG index spread with 5, 7, and 10yr maturity
plot_spreads_maturities(CDX_NA_IG2);

% Plot (normalized) history of tranche spreads
plot_historical_tranche_spreads(CDX_NA_IG2);

% Plot (normalized) history of tranche spread in May 2005
plot_historical_tranche_spreads(CDX_NA_IG2, datenum('05/02/2005'), datenum('05/31/2005'));
plot_historical_tranche_spreads(CDX_NA_IG2, datenum('04/02/2005'), datenum('05/18/2005'), [1 0 1 0 1]);
plot_historical_tranche_spreads(CDX_NA_IG2, datenum('04/11/2005'), datenum('05/18/2005'), [1 0 1 0 1]); legend off;

% Plot principal components of tranche spread changes
princomp_analysis(CDX_NA_IG2)

%%%%%%%%%%%%%%%%%%%%%%
% CDS specific plots %
%%%%%%%%%%%%%%%%%%%%%%

% Plot initial default intensities
semilogy(get_x_it(cdx_mor, cdx_mor.dates{1}(1)));

% Plot relative CDS pricing error over time for a specific company
plot_cds_mispricing(cdx_mor10, 'AA', [1 1 1 1]);
plot_cds_mispricing(cdx_mor10, 'ABS', [1 1 1 1]);
plot_cds_mispricing(cdx_mor10, 'DIS', [1 1 1 1]);

% Plot average 5-yr CDS mispricing (i.e. bias) over time
plot_cds_bias(cdx_new2, 1);
plot_cds_bias(cdx_new2, 4);

% Plot (i) 1-yr CDS spread/0.6, (ii) lambda_P, (iii) lambda_Q for a specific company
plot_fitted_intensities(cdx_tv_quarterly, 'AA', 1);
plot_fitted_intensities(cdx_tv_quarterly, 'ABS', 5);
plot_fitted_intensities(cdx_tv_monthly, 'AA', 1);
plot_fitted_intensities(cdx_tv_monthly, 'ABS', 5);
plot_fitted_intensities(cdx_tv_quarterly, 'LUV', 1);
plot_fitted_intensities(cdx_tv_quarterly, 'VZ', 1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Index and tranche specific plots %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Plot payoff structure of super senior tranche
plot_tranche_payoff(15, 30);

% Plot integrated affine jump diffusion
[density, dz] = density_integrated_ajd2_adaptive(0.01, 0.25, 0.02, 0.05, 0.02, 0.05, 5, 10000, 2, 1);
[density, dz] = density_integrated_ajd2_adaptive(0.01, 0.25, 0.02, 0.05, 0.02, 0.05, 5, 8192, 3, 1);
[density, dz] = density_integrated_ajd2_adaptive(0.0013, 0.0164, 0.01, 0.0825, 0.0028, 0.2270, 5, 10000, 2, 1);
axis([0 0.8 0 3])

% Plot model-implied distribution of number of defaults
plot_dist_num_def(cdx_mor, datenum('12/05/2005'), 5)

% Plot relative RMSE over time
plot_rmse(cdx_new2);

% Plot rho_n for LGD method 3
plot(1:length(rho_n), rho_n)
xlabel('rhon')
ylabel('numdef')
axis([0 125 0 1])

%%%%%%%%%%%%%%%%%%%%
% For monthly data %
%%%%%%%%%%%%%%%%%%%%

semilogy(get_x_it(CDX_NA_IG2_monthly, datenum('02/01/2006')));
plot_cds_bias(CDX_NA_IG2_monthly, 1)
plot_cds_bias(CDX_NA_IG2_monthly, 4)

[trash, CDX_NA_IG2_monthly] = wrapper_tranche_mispricing(get_x0(CDX_NA_IG2_monthly), CDX_NA_IG2_monthly, discounts_IMM, CDX_NA_IG2_monthly.dates{1}(1), CDX_NA_IG2_monthly.dates{1}(end), 2000, 0.7, [1 0 0 0], [1 0 0], 1, 1);                               
plot_rmse(CDX_NA_IG2_monthly)