%%%%%%%%%%%%%%%%%%%%%%
% CDS specific plots %
%%%%%%%%%%%%%%%%%%%%%%

% Plot initial default intensities
semilogy(get_x_it(cdx_tv_yearly, datenum('11/01/2006')));

% Plot average 5-yr CDS mispricing (i.e. bias) over time
plot_cds_bias(cdx_tv_monthly, 1);
plot_cds_bias(cdx_tv_monthly, 4);
plot_cds_bias(cdx_tv_weekly, 1);
plot_cds_bias(cdx_tv_weekly, 4);

% Plot relative CDS pricing error over time for a specific company
cdx_tv_monthly = fit_model_cds_portfolio(cdx_tv_monthly, discounts_IMM, cdx_tv_monthly.dates{1}(1), cdx_tv_monthly.dates{1}(end), [1 1 1 1]);
plot_cds_mispricing(cdx_tv_monthly, 'AA', [1 1 1 1]);
plot_cds_mispricing(cdx_tv_monthly, 'ABS', [1 1 1 1]);
plot_cds_mispricing(cdx_tv_monthly, 'DIS', [1 1 1 1]);
cdx_tv_weekly = fit_model_cds_portfolio(cdx_tv_weekly, discounts_IMM, cdx_tv_weekly.dates{1}(1), cdx_tv_weekly.dates{1}(end), [1 1 1 1]);
plot_cds_mispricing(cdx_tv_weekly, 'AA', [1 1 1 1]);
plot_cds_mispricing(cdx_tv_weekly, 'ABS', [1 1 1 1]);
plot_cds_mispricing(cdx_tv_weekly, 'DIS', [1 1 1 1]);
cdx_tv_monthly10 = fit_model_cds_portfolio(cdx_tv_monthly10, discounts_IMM, cdx_tv_monthly10.dates{1}(1), cdx_tv_monthly10.dates{1}(end), [1 1 1 1]);
plot_cds_mispricing(cdx_tv_monthly10, 'AA', [1 1 1 1]);
plot_cds_mispricing(cdx_tv_monthly10, 'ABS', [1 1 1 1]);
plot_cds_mispricing(cdx_tv_monthly10, 'DIS', [1 1 1 1]);

% Plot (i) 1-yr CDS spread/0.6, (ii) lambda_P, (iii) lambda_Q for a specific company
% AA
plot_fitted_intensities(cdx_tv_monthly, 'AA', 5);
plot_fitted_intensities(cdx_tv_weekly, 'AA', 1);
plot_fitted_intensities(cdx_tv_monthly10, 'AA', 1);
plot_fitted_intensities(cdx_tv_weekly, 'AA', 5);
% ABS
plot_fitted_intensities(cdx_tv_monthly, 'ABS', 5);
plot_fitted_intensities(cdx_tv_monthly10, 'ABS', 5);
plot_fitted_intensities(cdx_tv_weekly, 'ABS', 5);
% LUV
plot_fitted_intensities(cdx_tv_monthly, 'LUV', 5);
plot_fitted_intensities(cdx_tv_monthly10, 'LUV', 5);
plot_fitted_intensities(cdx_tv_monthly, 'LUV', 1);
plot_fitted_intensities(cdx_tv_monthly10, 'LUV', 1);
plot_fitted_intensities(cdx_tv_monthly10, 'LUV', 1, [1 1 1 1 1]);
plot_fitted_intensities(cdx_tv_weekly, 'LUV', 5);

% Plot either mean or median (i) 1-yr CDS spread/0.6, (ii) lambda_P, (iii) lambda_Q for the whole index

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Index and tranche specific plots %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Plot relative RMSE over time
plot_rmse(cdx_tv_yearly);
plot_rmse(cdx_tv_quarterly);
plot_rmse(cdx_tv_monthly);
plot_rmse(cdx_tv_weekly);
plot_rmse(cdx_tv_monthly10);

% Plot individual relative tranche pricing errors over time
plot_tranche_mispricing(cdx_tv_monthly, 1, 1)
plot_tranche_mispricing(cdx_tv_monthly, 1, 4, 0, CDX_NA_IG)
plot_tranche_mispricing(cdx_tv_monthly, 1, 5, 0, CDX_NA_IG, CDX_NA_IG_citi)
plot_tranche_mispricing(cdx_tv_monthly_lgd1, 1, 4, 0, CDX_NA_IG)
plot_tranche_mispricing(cdx_tv_weekly, 1, 4, 0, CDX_NA_IG)
plot_tranche_mispricing(cdx_tv_monthly10, 1, 4, 0, CDX_NA_IG)

% Add TS_CDS_vol and TS_VIX to plot above
TS_plot(TS_mult_double(TS_CDS_vol2, 0.3), 0, cdx_tv_monthly.dates{1}(1), cdx_tv_monthly.dates{1}(end))
hold all
plot_tranche_mispricing(cdx_tv_monthly, 1, 4, 0, CDX_NA_IG)
hold off
% TS_VIX
TS_plot(TS_mult_double(TS_VIX, 0.005), 0, cdx_tv_monthly.dates{1}(1), cdx_tv_monthly.dates{1}(end))
hold all
plot_tranche_mispricing(cdx_tv_monthly, 1, 4, 0, CDX_NA_IG)
hold off

%%%%%%%%%%%%%%%%%%%
% Parameter plots %
%%%%%%%%%%%%%%%%%%%

% Plot CDX parameters time series
plot_params_CDX(cdx_tv_monthly, 'Y');
plot_params_CDX(cdx_tv_monthly, 'k');
plot_params_CDX(cdx_tv_monthly, 'theta_total');
plot_params_CDX(cdx_tv_monthly, 'thet*k');
plot_params_CDX(cdx_tv_monthly, 'sigma');
plot_params_CDX(cdx_tv_monthly, 'L_Y');
plot_params_CDX(cdx_tv_monthly, 'L_total');
plot_params_CDX(cdx_tv_monthly, 'mu');
plot_params_CDX(cdx_tv_monthly, 'mu*L');
plot_params_CDX(cdx_tv_monthly, 'omega1');
plot_params_CDX(cdx_tv_monthly, 'omega2');
plot_params_CDX(cdx_tv_monthly, 'liq_prem_cds');
plot_params_CDX(cdx_tv_monthly, 'liq_prem_tranches');
% weekly fit
plot_params_CDX(cdx_tv_weekly, 'Y');
plot_params_CDX(cdx_tv_weekly, 'k');
plot_params_CDX(cdx_tv_weekly, 'theta_total');
plot_params_CDX(cdx_tv_weekly, 'thet*k');
plot_params_CDX(cdx_tv_weekly, 'sigma');
plot_params_CDX(cdx_tv_weekly, 'L_Y');
plot_params_CDX(cdx_tv_weekly, 'L_total');
plot_params_CDX(cdx_tv_weekly, 'mu');
plot_params_CDX(cdx_tv_weekly, 'mu*L');
plot_params_CDX(cdx_tv_weekly, 'omega1');
plot_params_CDX(cdx_tv_weekly, 'omega2');
plot_params_CDX(cdx_tv_weekly, 'liq_prem_cds');
plot_params_CDX(cdx_tv_weekly, 'liq_prem_tranches');

% Plot CDS loadings on common factor over time
plot_params_CDS(cdx_tv_monthly, 'a_i');
plot_params_CDS(cdx_tv_monthly, 'a_i', {'AA'; 'AIG'; 'DIS'; 'MOT'});
plot_params_CDS(cdx_tv_monthly, 'sigma_i');
plot_params_CDS(cdx_tv_monthly, 'sigma_i', {'AA'; 'AIG'; 'DIS'; 'MOT'});
plot_params_CDS(cdx_tv_monthly, 'theta_i');
plot_params_CDS(cdx_tv_monthly, 'theta_i', {'AA'; 'AIG'; 'DIS'; 'MOT'});
plot_params_CDS(cdx_tv_monthly, 'theta_i', {'GM'; 'F'; 'ABS'});
%plot_params_CDS(cdx_tv_monthly, 'L_i');
plot_params_CDS(cdx_tv_monthly, 'L_i',  {'AA'; 'AIG'; 'DIS'; 'MOT'});
plot_params_CDS(cdx_tv_monthly, 'mu_i');
plot_params_CDS(cdx_tv_monthly, 'mu_i', {'AA'; 'AIG'; 'DIS'; 'MOT'});
plot_params_CDS(cdx_tv_monthly, 'mu_i', {'GM'; 'F'; 'ABS'});
plot_params_CDS(cdx_tv_monthly, 'X_i');
plot_params_CDS(cdx_tv_monthly, 'X_i', {'AA'; 'AIG'; 'DIS'; 'MOT'});
plot_params_CDS(cdx_tv_monthly, 'X_i', {'GM'; 'F'; 'ABS'});
plot_params_CDS(cdx_tv_monthly, 'lambda_i');
plot_params_CDS(cdx_tv_monthly, 'lambda_i', {'AA'; 'AIG'; 'DIS'; 'MOT'});
plot_params_CDS(cdx_tv_monthly, 'lambda_i', {'GM'; 'F'; 'ABS'});

