function make_nice_axis(gca, values, eps)
% Make axis such that maximum x and y value are nice numbers

if (nargin < 3)
    eps = 0.02;
end

overall_max = max(values) * (1+eps);
overall_min = min(min(values), 0);
overall_diff = overall_max - overall_min;
if (overall_diff < 1e-9)
    unit = 1e-10;
elseif (overall_diff < 2e-9)
    unit = 2e-10;
elseif (overall_diff < 5e-9)
    unit = 5e-10;
elseif (overall_diff < 1e-8)
    unit = 1e-9;
elseif (overall_diff < 2e-8)
    unit = 2e-9;
elseif (overall_diff < 5e-8)
    unit = 5e-9;
elseif (overall_diff < 1e-7)
    unit = 1e-8;
elseif (overall_diff < 2e-7)
    unit = 2e-8;
elseif (overall_diff < 5e-7)
    unit = 5e-8;
elseif (overall_diff < 1e-6)
    unit = 1e-7;
elseif (overall_diff < 2e-6)
    unit = 2e-7;
elseif (overall_diff < 5e-6)
    unit = 5e-7;
elseif (overall_diff < 1e-5)
    unit = 1e-6;
elseif (overall_diff < 2e-5)
    unit = 2e-6;
elseif (overall_diff < 5e-5)
    unit = 5e-6;
elseif (overall_diff < 1e-4)
    unit = 1e-5;
elseif (overall_diff < 2e-4)
    unit = 2e-5;
elseif (overall_diff < 5e-4)
    unit = 5e-5;
elseif (overall_diff < 1e-3)
    unit = 1e-4;
elseif (overall_diff < 2e-3)
    unit = 2e-4;
elseif (overall_diff < 5e-3)
    unit = 5e-4;
elseif (overall_diff < 1e-2)
    unit = 1e-2;
elseif (overall_diff < 2e-2)
    unit = 2e-3;
elseif (overall_diff < 0.05)
    unit = 0.005;
elseif (overall_diff < 0.1)
    unit = 0.01;
elseif (overall_diff < 0.2)
    unit = 0.02;
elseif (overall_diff < 0.5)
    unit = 0.05;
elseif (overall_diff < 1)
    unit = 0.1;
elseif (overall_diff < 2)
    unit = 0.2;
elseif (overall_diff < 5)
    unit = 0.5;
elseif (overall_diff < 10)
    unit = 1;
elseif (overall_diff < 20)
    unit = 2;
elseif (overall_diff < 50)
    unit = 5;
elseif (overall_diff < 100)
    unit = 10;
elseif (overall_diff < 200)
    unit = 20;
elseif (overall_diff < 500)
    unit = 50;
elseif (overall_diff < 1000)
    unit = 100;
else
    unit = 200;
end
overall_max = ceil(overall_max / unit) * unit;
overall_min = floor(overall_min / unit) * unit;

ticks = get(gca,['x','tick']);
axis([min(ticks) max(ticks) overall_min overall_max*1.000001]);