function make_nice_ticks(date_nums, diff, offset, datestr_type)
% Make nice ticks and labels on x-axis ('diff' days apart)

if (nargin < 3)
    offset = 0;
end
if (nargin < 4)
    datestr_type = 12;
end

monthly_dates = get_first_date_month(date_nums);
monthly_pos = monthly_dates - date_nums(1);
ticks = [0];
counter = 2;
while (counter <= length(monthly_pos))
    if (monthly_pos(counter) - ticks(end) >= diff)
        ticks = [ticks monthly_pos(counter)];
    end
    counter = counter + 1;
end

%ticks = (0:diff:(date_nums(end)-date_nums(1)));
ticks = [ticks ticks(end)+diff];
set(gca,'xtick', ticks);
set(gca,['x','ticklabel'], datestr(date_nums(1)+ticks-offset, datestr_type));