function avg_bias = plot_cds_bias(CDX, maturity, use_abs, do_plot, dates)
% --------------------------------------------------------------------------------------------------
% Plot average pricing bias over time for a certain maturity
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% maturity  ... for which maturity to plot bias
% use_abs   ... whether to plot sum of absolute of just sum of pricing erros
% do_plot   ... whether to actually plot the thing
% dates     ... which dates to use, default: all
% --------------------------------------------------------------------------------------------------
% sample call: plot_cds_bias(cdx_new, 1)
% --------------------------------------------------------------------------------------------------

% By default, plot just sum of errors
if (nargin <= 2)
    use_abs = 0;
end
if (nargin <= 3)
    do_plot = 1;
end
if (nargin <= 4)
    dates = CDX.dates{1};
end

% Extract average bias
if (length(dates) == 1);
    bias_cds = [];
end
sum_errors = zeros(size(dates));
counts = zeros(size(dates));
for i=1:length(dates)
    date = dates(i);
    for j=1:length(CDX.portfolio)
        if (CDX.index_members(i,j) == 1)
            % Determine date_pos
            cds = CDX.portfolio(j);
            date_pos = find(cds.dates{maturity} == date);
            if (~isempty(date_pos))
                if (use_abs == 0)
                    bias = cds.model_price{maturity}(date_pos) - cds.market_price{maturity}(date_pos);
                else
                    bias = abs(cds.model_price{maturity}(date_pos) - cds.market_price{maturity}(date_pos));
                end
                if (length(dates) == 1)
                    bias_cds = [bias_cds; bias];
                end
                if (abs(bias)>15)
                    %disp(j);
                    %disp(bias);
                end
                sum_errors(i) = sum_errors(i) + bias;
                counts(i) = counts(i) + 1;
            end
        end
    end
end
avg_bias = sum_errors ./ counts;

if (do_plot == 1)
    % Plot average bias
    dates_scale = datenum(dates)-datenum(dates(1));
    plot(dates_scale, avg_bias, 'LineWidth', 1.2, 'Marker', '+')
    ylabel('bps')
    make_nice_axis(gca, avg_bias);
    make_nice_ticks(dates, 60);
end

% % Plot bias across cds
% if (length(dates)==1)
%     uiwait;
%     plot(bias_cds);
% end
