function plot_cds_history(CDX, ticker)
% --------------------------------------------------------------------------------------------------
% Plot CDS spread history for a company.
% --------------------------------------------------------------------------------------------------
% ticker    ... ticker symbol for ocmpany of interest
% --------------------------------------------------------------------------------------------------
% sample call: plot_cds_history(CDX_NA_IG2, 'AA')
% --------------------------------------------------------------------------------------------------

% Extract relevant CDS
all_tickers = {CDX.portfolio.ticker};
pos = strcmp(all_tickers, ticker);
cds = CDX.portfolio(pos);

% Make plot of CDS spread history
dates_scale = datenum(cds.dates{1})-datenum(cds.dates{1}(1));
plot(dates_scale, cds.market_price{1}, 'LineWidth', 1.2)
hold all
dates_scale = datenum(cds.dates{2})-datenum(cds.dates{1}(1));
plot(dates_scale, cds.market_price{2}, 'LineWidth', 1.2, 'Color', 'Red', 'LineStyle', '--')
dates_scale = datenum(cds.dates{3})-datenum(cds.dates{1}(1));
plot(dates_scale, cds.market_price{3}, 'LineWidth', 1.2, 'Color', 'Green', 'LineStyle', '-.')
dates_scale = datenum(cds.dates{4})-datenum(cds.dates{1}(1));
plot(dates_scale, cds.market_price{4}, 'LineWidth', 1.2, 'Color', 'Magenta', 'LineStyle', ':')
hold off
ylabel('bps')

make_nice_axis(gca, [cds.market_price{1}; cds.market_price{2}; cds.market_price{3}; cds.market_price{4}]);
make_nice_ticks(cds.dates{1}, 120);