function plot_cds_mispricing(CDX, ticker, maturities)
% --------------------------------------------------------------------------------------------------
% Plot individual tranche pricing errors over time.
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure (see 'all_steps_in_a_row.m')
% ticker            ... ticker symbol for ocmpany of interest
% maturities        ... pricing errors of which maturities to plot 
% --------------------------------------------------------------------------------------------------
% sample call: plot_cds_mispricing(cdx_tv_monthly, 'AA', [1 1 1 1])
% --------------------------------------------------------------------------------------------------

% Extract relevant CDS
all_tickers = {CDX.portfolio.ticker};
pos = strcmp(all_tickers, ticker);
cds = CDX.portfolio(pos);

% Make plot
color_matrix = [[0 0 1]; [1 0 0]; [0 0 0]; [1 0 1]; [0 1 1]; [0 0 0]];
line_styles = {'-' '--' ':' '-.' '-' '--' ':' '-.'};
markers = {'none' 'none' 'none' 'none' 'x' 'x' 'x' 'x'};
markers2 = {'o' 'x' 'v' '*'};
counter = 0;
data = [];
used_maturities = zeros(size(maturities));
for i=1:length(maturities)
    if (maturities(i) == 0)
        continue;
    end
    if isempty(cds.model_price{i})
        continue;
    end
        
    % Calculate relative pricing errors
    counter = counter + 1;
    used_maturities(i) = 1;
    market_price = cds.market_price{i};
    model_price = cds.model_price{i};
    rel_error = (model_price - market_price) ./ market_price;
    data = [data; rel_error];
    
    % Plot relative error over time
    if (counter == 2)
        hold on;    
    end
    date_scale = cds.dates{i} - cds.dates{1}(1);
    if (length(rel_error) > 1)
        plot(date_scale, rel_error, 'LineWidth', 1.2, 'Color', color_matrix(counter,:), 'LineStyle', line_styles{counter}, 'Marker', markers{counter});    
    else
        scatter(date_scale, rel_error, 'MarkerEdgeColor', color_matrix(counter,:), 'Marker', markers2{counter}, 'SizeData', 49, 'LineWidth', 1.2);
    end
end
hold off

% Make nice axes & labels
legend_text = {'5yr', '7yr', '10yr', '1yr'};
legend({legend_text{logical(used_maturities)}});
legend('Location', 'NorthEast')
make_nice_axis(gca, data);
make_nice_ticks(cds.dates{1}, 122);

