function plot_credit_events(start_date)
% --------------------------------------------------------------------------------------------------
% Auxiliary function that plots certain credit events
% --------------------------------------------------------------------------------------------------
% start_date    ... reference point for plot
% --------------------------------------------------------------------------------------------------
% sample call: plot_credit_events(CDX_NA_IG2.dates)
% --------------------------------------------------------------------------------------------------

% Define credit events
event_date = {'05/05/2005' '10/08/2005' '06/21/2006'};
event_name = {'GM&F' 'Delphi' 'EM Sell-off'};

% Add lines add events
for i=1:length(event_date)
    date = datenum(event_date{i}) - start_date;
    line([date date], [-1e6 1e6], 'Color', 'Black')
end