function plot_dist_num_def(CDX, date, T)
% --------------------------------------------------------------------------------------------------
% Plot model-implied distribution of number of defaults
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% date              ... date for which to compute implied portfolio loss distribution
% T                 ... horizon for distribution
% --------------------------------------------------------------------------------------------------
% sample call: plot_dist_num_def(cdx_mor, datenum('12/05/2005'), 5)
% --------------------------------------------------------------------------------------------------

% Find position of used date
date_pos = find(CDX.dates{1} == date);

% Calculate  model-implied distribution of number of defaults
dist_num_def = port_loss_dist2(CDX.dates{1}(date_pos), [0 T], CDX.portfolio, CDX.index_members(date_pos,:), CDX.y0(date_pos), ...
                               CDX.AJD_common_factor, 10000, CDX.liq_prem_tranches);
dist_num_def = squeeze(dist_num_def(1,end,:));        
            
% Make nice bar graph
max_def = 25;
bar(0:max_def, dist_num_def(1:(max_def+1)));
h = findobj(gca,'Type','patch');
set(h,'FaceColor','r')
if(1)
    xlabel('Number of Defaults')
    ylabel('Probability')
else
    xlabel('numdef')
    ylabel('prob')
end
axis([-1 max_def+1 0 0.18]);