function plot_intensity_idosyncratic(cds)
% --------------------------------------------------------------------------------------------------
% Make a nice plot of the idiosyncratic default intensity component
% --------------------------------------------------------------------------------------------------
% cds       ... credit default swap structure (see 'all_steps_in_a_row.m')
% --------------------------------------------------------------------------------------------------
% sample call: plot_intensity_idosyncratic(cds_new)
% --------------------------------------------------------------------------------------------------

% Extract dates and values to plot
dates = cds.dates{1};
values = cds.x0 * 1e4;
values2 = cds.market_price{1};

% Extract parameters for plot
total_max = max([ max(values) max(values2) ]);
total_min = min([ min(values) min(values2) ]);
dates_scale1 = datenum(dates)-datenum(dates(1));

% Visualize historical index prices
plot(dates_scale1, values, 'LineWidth', 1.2)
hold all
plot(dates_scale1, values2, 'LineWidth', 1.2, 'Color', 'Red', 'LineStyle', '--')
ylabel('bps')
ticks = get(gca,['x','tick']);
set(gca,['x','ticklabel'], datestr(dates(1)+ticks, 12));
axis([min(dates_scale1) max(dates_scale1) 0 total_max]);
hold off