function plot_params_CDX(CDX, param)
% --------------------------------------------------------------------------------------------------
% Plot CDX-specific parameter time series
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure
% param     ... which parameter to plot
% --------------------------------------------------------------------------------------------------
% sample call: plot_params_CDX(cdx_tv_quarterly, 'k');
% --------------------------------------------------------------------------------------------------

% Extract desired parameter time series
x0 = get_x0(CDX, CDX.dates{1}, 'mu*L', 'thet*k');
switch param
    case 'Y'
        values = CDX.y0;
    case {'k' 'sigma' 'mu'}
        values = CDX.AJD_common_factor.(param);
    case 'theta_total'
        values = x0{2} ./ x0{1};
    case 'thet*k'
        values = x0{2};
    case 'L_Y'
        values = CDX.AJD_common_factor.L;
    case 'L_total'
        values = x0{4};
    case 'mu*L'
        values = x0{5};
    case 'omega1'
        values = x0{6};
    case 'omega2'
        values = x0{7};
    case {'liq_prem_cds' 'liq_prem_tranches'}
        values = CDX.(param);
end
    
% Make plot
dates = CDX.dates{1};
date_scale = dates - dates(1);
plot(date_scale, values, 'LineWidth', 1.2)

% Make nice axes & labels
special = strfind(param, '_');
for i=length(special):(-1):1
    param = [param(1:(special(i)-1)) param((special(i)+1):end)];
end
ylabel(param);
make_nice_axis(gca, values);
make_nice_ticks(dates, 122);