function plot_rmse(CDX)
% --------------------------------------------------------------------------------------------------
% Plot relative RMSE over time
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% --------------------------------------------------------------------------------------------------
% sample call: plot_rmse(cdx_new)
% --------------------------------------------------------------------------------------------------

% Plot average bias
dates = CDX.dates{1};
dates_scale = datenum(dates)-datenum(dates(1));
plot(dates_scale, CDX.rmse, 'LineWidth', 1.2, 'Marker', '+')
ylabel('relrmse');

make_nice_axis(gca, CDX.rmse);
make_nice_ticks(dates, 120);