function plot_rollover_dates(start_date)
% --------------------------------------------------------------------------------------------------
% Auxiliary function that plots vertical lines for all rollover dates
% --------------------------------------------------------------------------------------------------
% start_date    ... reference point for plot
% --------------------------------------------------------------------------------------------------
% sample call: plot_rollover_dates(CDX_NA_IG2.dates)
% --------------------------------------------------------------------------------------------------

% Extract roll-over dates
rollover_dates = {'3/22/2004' '9/20/2004' '3/21/2005' '9/20/2005' '3/20/2006' '9/20/2006' ...
                  '3/20/2007' '9/20/2007' '3/20/2008' '9/22/2008'};
rollover_dates = datenum(rollover_dates);

% Add lines add rollover dates
rollover_dates_num = rollover_dates - start_date;
for i=1:length(rollover_dates_num)
    line([rollover_dates_num(i) rollover_dates_num(i)], [1e-6 1e6], 'Color', 'Black')
end