function plot_spreads_maturities(CDX)
% --------------------------------------------------------------------------------------------------
% Make a nice plot of CDX.NA.IG index spread with 5, 7, and 10yr maturity
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% --------------------------------------------------------------------------------------------------
% sample call: plot_spreads_maturities(CDX_NA_IG2)
% --------------------------------------------------------------------------------------------------


% Extract parameters for plot
start_date = CDX.dates{1}(1); %datenum('09/01/2003');
end_date = CDX.dates{1}(end); %datenum('09/12/2006');
prices1 = CDX.index_market_price{1};
used1 = prices1 > 0;
prices2 = CDX.index_market_price{2};
used2 = prices2 > 0;
prices3 = CDX.index_market_price{3};
used3 = prices3 > 0;

dates_scale1 = CDX.dates{1} - start_date;
dates_scale2 = CDX.dates{2} - start_date;
dates_scale3 = CDX.dates{3} - start_date;

% Visualize historical index prices
plot(dates_scale1(used1), prices1(used1), 'LineWidth', 1.2)
hold all
plot(dates_scale2(used2), prices2(used2), 'LineWidth', 1.2, 'Color', 'Red', 'LineStyle', '--')
plot(dates_scale3(used3), prices3(used3), 'LineWidth', 2, 'Color', 'Black', 'LineStyle', ':')
hold off
ylabel('spread')
ticks = get(gca,['x','tick']);

% Plot rollover dates
axis([0 end_date-start_date 30 110]);
make_nice_ticks(CDX.dates{1}, 123, dates_scale1(1));
plot_rollover_dates(start_date);

% Plot certain credit events
%plot_credit_events(start_date);