function TS_syst_ratio = plot_syst_risk_fraction(CDX)
% --------------------------------------------------------------------------------------------------
% Plot the fraction of systematic risk Y_t / median(lambda_t^Q) and Y_t / mean(lambda_t^Q) over
% time.
% --------------------------------------------------------------------------------------------------
% CDX           ... credit index structure
% --------------------------------------------------------------------------------------------------
% sample call: plot_syst_risk_fraction(cdx_tv_monthly10);
% --------------------------------------------------------------------------------------------------

% Extract TS_Y
TS_Y = struct('dates', CDX.dates{1}, 'values', CDX.y0);

% Extract relevant time series
TS_lambda_Q = {};
for i=1:length(CDX.portfolio)
    % Calculate lambda_Q
    cds = CDX.portfolio(i);
    TS_X_it = struct('dates', cds.dates{1}, 'values', cds.x0);
    TS_a_it_Q = struct('dates', cds.dates{1}, 'values', cds.ai);
    TS_lambda_Q{i,1} = TS_add_TS(TS_mult_TS(TS_Y, TS_a_it_Q), TS_X_it);   
end

% Calculate ratio
TS_med_lambda_Q = TS_matrix_function(TS_lambda_Q, @median);
TS_avg_lambda_Q = TS_matrix_function(TS_lambda_Q, @mean);
TS_syst_ratio = TS_divide_TS(TS_Y, TS_med_lambda_Q);
TS_syst_ratio2 = TS_divide_TS(TS_Y, TS_avg_lambda_Q);

% Make the actual plot
TS_vector_plot({TS_syst_ratio TS_syst_ratio2})
legend({'median ratio' 'mean ratio'});
