function plot_tranche_mispricing(CDX, maturity, method, slides, CDX2, CDX3)
% --------------------------------------------------------------------------------------------------
% Plot individual tranche pricing errors over time.
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure (see 'all_steps_in_a_row.m')
% maturity          ... pricing errors of which maturity to plot 
% method            ... which errors to plot:
%                       0 ... absolute RMSE
%                       1 ... relative RMSE
%                       2 ... RMSE weighted by inverse of tranche bid-ask
%                       3 ... RMSE weighted by tranche notional size
%                       4 ... robust version of 1, set error = 0 if model-price between mid-price of
%                       5 ... same as 4, but with three CDX structures
%                       CDX and CDX2
% slides            ... if equal to one, use different labels (for slides)
% CDX2              ... second CDX structure for robust RMSE calculation (method 4)
% CDX3              ... third CDX structure for robust RMSE calculation (method 5)
% --------------------------------------------------------------------------------------------------
% sample call: plot_tranche_mispricing(cdx_tv_quarterly, 1, 1)
%              plot_tranche_mispricing(cdx_tv_monthly, 1, 4, 0, CDX_NA_IG)
% --------------------------------------------------------------------------------------------------

if (nargin <= 3)
    slides = 0;
end
if (nargin <= 4)
    CDX2 = [];
end
if (nargin <= 5)
    CDX3 = [];
end

% Calculate pricing errors
maturities = ([1 2 3] == maturity);
if (method <=3)
    [trash, trash2, errors] = RMSE_tranche_mispricing2(CDX, CDX.dates{1}(1), CDX.dates{1}(end), maturities, method, 0);
elseif (method == 4)
    [trash, trash2, errors] = RMSE_tranche_mispricing2(CDX, CDX.dates{1}(1), CDX.dates{1}(end), maturities, method, 0, CDX2);
elseif (method == 5)
    [trash, trash2, errors] = RMSE_tranche_mispricing2(CDX, CDX.dates{1}(1), CDX.dates{1}(end), maturities, method, 0, CDX2, CDX3);
end

% Make plot
color_matrix = [[0 0 1]; [1 0 0]; [0 0 0]; [1 0 1]; [0 1 1]; [0 0 0]];
line_styles = {'-' '--' ':' '-.' '-' '--' ':' '-.'};
markers = {'none' 'none' 'none' 'none' 'x' 'x' 'x' 'x'};
date_scale = CDX.dates{1} - CDX.dates{1}(1);
plot(date_scale, errors(:,1), 'LineWidth', 1.2, 'Color', color_matrix(1,:), 'LineStyle', line_styles{1}, 'Marker', markers{1});
hold on;
plot(date_scale, errors(:,2), 'LineWidth', 1.2, 'Color', color_matrix(2,:), 'LineStyle', line_styles{2}, 'Marker', markers{2});
plot(date_scale, errors(:,3), 'LineWidth', 1.2, 'Color', color_matrix(3,:), 'LineStyle', line_styles{3}, 'Marker', markers{3});
plot(date_scale, errors(:,4), 'LineWidth', 1.2, 'Color', color_matrix(4,:), 'LineStyle', line_styles{4}, 'Marker', markers{4});
plot(date_scale, errors(:,5), 'LineWidth', 1.2, 'Color', color_matrix(5,:), 'LineStyle', line_styles{5}, 'Marker', markers{5});
hold off

% Make nice axes & labels
legend('Equity', 'Junior Mezzanine', 'Mezzanine', 'Senior', 'Super Senior');
legend('Location', 'NorthEast')
make_nice_axis(gca, reshape(errors, [numel(errors) 1]));
make_nice_ticks(CDX.dates{1}, 120);
if (slides == 0)
    ylabel('modellessmarket');
else
    ylabel('Relative Overpricing');
end

% Plot certain credit events
%plot_credit_events(CDX.dates{1}(1));


