function plot_tranche_payoff(lower, upper) 
% Plot payoff structure of a tranche
% Sample call: plot_tranche_payoff(15, 30)

x = 0:0.1:(upper*1.5);
y = min(upper-lower, max(x-lower, 0));
plot(x, y, 'LineWidth', 1.2);
xlabel('Percentage Loss');
ylabel('Payout');
axis([0 upper*1.5 0 round((upper-lower)*1.2)]);