function princomp_analysis(CDX)
% --------------------------------------------------------------------------------------------------
% Perform a principal component analyisis on the multivariate time-series of tranche spread changes.
% --------------------------------------------------------------------------------------------------
% CDX           ... credit index structure
% --------------------------------------------------------------------------------------------------
% sample call: princomp_analysis(CDX_NA_IG2)
% --------------------------------------------------------------------------------------------------


% Extract data
dates = CDX.dates{1};
coupon = CDX.tranche_market_price_mid{1}(:,2:end);
up_front = CDX.tranche_market_upfront_mid{1}(:,1);
data = [up_front coupon];
data = data ./ repmat(data(1,:), size(data,1), 1);

% Calculate price changes and standardize them
returns = diff(data);
returns_std = returns ./ repmat(std(returns), size(returns,1), 1);
[coefs,scores,variances] = princomp(returns_std);
coefs(:,2:3) = coefs(:,2:3 );   % for better interpretation
disp('Principal components:')
disp(coefs);
disp('Variance explained:')
disp(variances/length(variances));
disp('Cumulative variance explained:')
disp(cumsum(variances)/length(variances));
component_returns = returns_std * coefs;

% Evolution of components over time
start_date = datenum('09/01/2003');
end_date = datenum('01/7/2007');
dates = CDX.dates{1}(1:end);
component_returns = [zeros(1, size(component_returns, 2)); component_returns];
dates_scale = dates - start_date;
plot(dates_scale, cumsum(component_returns(:,1)), 'LineWidth', 1.2)
hold all
plot(dates_scale, cumsum(component_returns(:,2)), 'LineWidth', 1.2, 'Color', 'Red', 'LineStyle', '--')
plot(dates_scale, cumsum(component_returns(:,3)), 'LineWidth', 2, 'Color', 'Black', 'LineStyle', ':')
hold off

% Add labels
ylabel('princompreturn')
axis([0 end_date-start_date -60 30]);
make_nice_ticks(dates, 153, dates_scale(1));