function visualize_cds_notional(notional_amounts, dates, type)
% --------------------------------------------------------------------------------------------------
% Visualize notional amount (in $trn) of outstanding credit default swaps
% --------------------------------------------------------------------------------------------------
% type ... 1 = use axes labels of type '2006', 2 = use axes labels of type '06H1'
% --------------------------------------------------------------------------------------------------
% Sample call: visualize_cds_notional(cdsNotionalOutstanding, rowheaders, 2)
% --------------------------------------------------------------------------------------------------

% Import data (currently done manually)
notional_amounts = notional_amounts(:,1) / 1000;

% Convert dates into numbers
num_dates = [];
for i=1:length(dates)
   year = str2double(dates{i}(3:4));
   half_year = str2double(dates{i}(1));
   num_dates = [num_dates (year+2000+(half_year-1)/2)];
end

% Make nice bar graph
if (type == 1)
    bar(num_dates, notional_amounts);
elseif (type == 2)
    bar(1:length(notional_amounts), notional_amounts);
    set(gca,['x','ticklabel'],dates)
end
h = findobj(gca,'Type','patch');
set(h,'FaceColor','r')
xlabel('year')
ylabel('notional')