function cdx_new = subperiod_cdx2(CDX, date_nums)
% --------------------------------------------------------------------------------------------------
% Cut down the CDX to a sub-period.
% --------------------------------------------------------------------------------------------------
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% date_nums                     ... dates to which to cut down CDX structure
% --------------------------------------------------------------------------------------------------
% sample call: subperiod_cdx2(CDX_NA_IG2, [datenum('09/21/2004'); datenum('01/12/2005'); datenum('01/11/2006')])
% --------------------------------------------------------------------------------------------------

% Cut down CDX specific data
for i=1:length(CDX.dates)
    % Select data
    used_pos = logical(is_member_sorted_c(CDX.dates{i}, date_nums));
    CDX.dates{i} = CDX.dates{i}(used_pos);
    CDX.T{i} = CDX.T{i}(used_pos);
    CDX.index_market_price{i} = CDX.index_market_price{i}(used_pos);
    CDX.tranche_market_price_mid{i} = CDX.tranche_market_price_mid{i}(used_pos,:);
    CDX.tranche_market_upfront_mid{i} = CDX.tranche_market_upfront_mid{i}(used_pos,:);
    if (i==1)
        % CDX fields
        CDX.index_members = CDX.index_members(used_pos,:);
        if isfield(CDX, 'y0')
            CDX.y0 = CDX.y0(used_pos);
        end
        if isfield(CDX, 'liq_prem_tranches')
            CDX.liq_prem_tranches = CDX.liq_prem_tranches(used_pos);
        end
        if isfield(CDX, 'liq_prem_cds')
            CDX.liq_prem_cds = CDX.liq_prem_cds(used_pos);
        end
        if isfield(CDX, 'rmse_avg_cds')
            CDX.rmse_avg_cds = CDX.rmse_avg_cds(used_pos);
        end
        if isfield(CDX, 'rmse_5yr_cds')
            CDX.rmse_5yr_cds = CDX.rmse_5yr_cds(used_pos);
        end
        if isfield(CDX, 'rmse')
            CDX.rmse = CDX.rmse(used_pos);
        end
        if isfield(CDX, 'rmse_index')
            CDX.rmse_index = CDX.rmse_index(used_pos);
        end
        if isfield(CDX, 'rmse_tranches')
            CDX.rmse_tranches = CDX.rmse_tranches(used_pos);
        end
        
        % AJD fields        
        if (isfield(CDX, 'AJD_common_factor'))
            CDX.AJD_common_factor.k     = CDX.AJD_common_factor.k(used_pos);
            CDX.AJD_common_factor.theta = CDX.AJD_common_factor.theta(used_pos);
            CDX.AJD_common_factor.sigma = CDX.AJD_common_factor.sigma(used_pos);
            CDX.AJD_common_factor.L     = CDX.AJD_common_factor.L(used_pos);
            CDX.AJD_common_factor.mu    = CDX.AJD_common_factor.mu(used_pos);
            CDX.AJD_common_factor.dates = CDX.AJD_common_factor.dates(used_pos);
        end
    end
    if (isfield(CDX, 'tranche_model_upfront') & (length(CDX.tranche_model_upfront) >= i))
        CDX.tranche_model_upfront{i} = CDX.tranche_model_upfront{i}(used_pos,:);
    end
    if (isfield(CDX, 'tranche_model_price') & (length(CDX.tranche_model_price) >= i))
        CDX.tranche_model_price{i} = CDX.tranche_model_price{i}(used_pos,:);
    end
    if (isfield(CDX, 'index_model_price') & (length(CDX.index_model_price) >= i))
        CDX.index_model_price{i} = CDX.index_model_price{i}(used_pos,:);
    end
    if (isfield(CDX, 'index_PV01') & (length(CDX.index_PV01) >= i))
        CDX.index_PV01{i} = CDX.index_PV01{i}(used_pos,:);
    end
    if (isfield(CDX, 'delta_tr_idx_GC') & (length(CDX.delta_tr_idx_GC) >= i))
        CDX.delta_tr_idx_GC{i} = CDX.delta_tr_idx_GC{i}(used_pos,:);
    end
    if (isfield(CDX, 'PV01') & (length(CDX.PV01) >= i))
        CDX.PV01{i} = CDX.PV01{i}(used_pos,:);
    end
end

% Only keep CDS that are in index at least once
used_cds = sum(CDX.index_members, 1) > 0;
CDX.index_members = CDX.index_members(:,used_cds);
CDX.portfolio = CDX.portfolio(used_cds);

% Cut down CDS specific data
for j=1:length(CDX.portfolio)
    cds = CDX.portfolio(j);
    
    for i=1:length(cds.dates)
        % Select data
        used_pos = logical(is_member_sorted_c(cds.dates{i}, date_nums));
        cds.dates{i} = cds.dates{i}(used_pos);
        cds.market_price{i} = cds.market_price{i}(used_pos);
        cds.T{i} = cds.T{i}(used_pos);
        if (isfield(cds, 'model_price') & (length(cds.model_price)>0) & (length(cds.model_price{i}) == length(cds.dates{i})))
            cds.model_price{i} = cds.model_price{i}(used_pos);
        else
            cds.model_price = {[] [] [] []};
        end
        if (i==1)
            % CDS fields
            cds.rating = cds.rating(used_pos);
            if (length(cds.x0) > 0)
                cds.x0 = cds.x0(used_pos);
            end
            if (isfield(cds, 'debt') & (length(cds.debt)>0))
                cds.debt = cds.debt(used_pos);
            end
            if (isfield(cds, 'mcap') & (length(cds.mcap)>0))
                cds.mcap = cds.mcap(used_pos);
            end
            if (isfield(cds, 'share_price') & (length(cds.share_price)>0))
                cds.share_price = cds.share_price(used_pos);
            end
            if (isfield(cds, 'intensity_P') & (length(cds.intensity_P)>0))
                cds.intensity_P = cds.intensity_P(used_pos);
            end
            if (isfield(cds, 'DTD') & (length(cds.DTD)>0))
                cds.DTD = cds.DTD(used_pos);
            end
            if (isfield(cds, 'assets') & (length(cds.assets)>0))
                cds.assets = cds.assets(used_pos);
            end
            if (isfield(cds, 'return1yr') & (length(cds.return1yr)>0))
                cds.return1yr = cds.return1yr(used_pos);
            end
            if (isfield(cds, 'ai') & (length(cds.ai)>0))
                if (length(cds.ai) == length(used_pos))
                    cds.ai = cds.ai(used_pos);
                else
                    cds.ai = repmat(1, sum(used_pos), 1);
                end
            end
            if (isfield(cds, 'bi') & (length(cds.bi)>0))
                cds.bi = cds.bi(used_pos);
            end
            
            % AJD fields
            if (isfield(cds, 'AJD'))
                if (length(cds.AJD.k) == length(used_pos))
                    cds.AJD.k     = cds.AJD.k(used_pos);
                    cds.AJD.theta = cds.AJD.theta(used_pos);
                    cds.AJD.sigma = cds.AJD.sigma(used_pos);
                    cds.AJD.L     = cds.AJD.L(used_pos);
                    cds.AJD.mu    = cds.AJD.mu(used_pos);
                    cds.AJD.dates = cds.AJD.dates(used_pos);
                else
                    cds.AJD.k     = repmat(1, sum(used_pos), 1);
                    cds.AJD.theta = repmat(1, sum(used_pos), 1);
                    cds.AJD.sigma = repmat(1, sum(used_pos), 1);
                    cds.AJD.L     = repmat(1, sum(used_pos), 1);
                    cds.AJD.mu    = repmat(1, sum(used_pos), 1);
                    cds.AJD.dates = repmat(1, sum(used_pos), 1);
                end
            end
        end
    end
    if (j==1)
        new_port = cds;
    else
        new_port(j) = cds;
    end
end
CDX.portfolio = new_port;
cdx_new = CDX;
