function table1(CDX, start_date_num, end_date_num)
% --------------------------------------------------------------------------------------------------
% Creat a summary table ratings, CDS spreads, ...
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure which this CDX is part of (because need y0 & dynamics of common factor)
% start_date_num    ... optional datenum of start date, default: use all dates
% end_date_num      ... optional datenum of end date, default: use all dates
% --------------------------------------------------------------------------------------------------
% sample call: table1(CDX_NA_IG2, datenum('03/17/2006'), datenum('03/31/2006'))
% --------------------------------------------------------------------------------------------------

% Set default parameter values
if (nargin <= 1)
    start_date_num = CDX.dates{1}(1);
    end_date_num = CDX.dates{1}(end);
end

% Allocate memory
ratings = {'AAA' 'AA' 'A' 'BBB' 'BB' 'B'};
moodys_1yr_default_rates = {'0.00%' '0.08%' '0.08%' '0.30%' '1.43%' '4.48%'};
moodys_5yr_default_rates = {'0.20%' '0.97%' '1.37%' '3.51%' '10.04%' '20.89%'};
counts = zeros(size(ratings));
counts_1yr = zeros(size(ratings));
sum_spreads = zeros(size(ratings));
sum_spreads_1yr = zeros(size(ratings));
sum_lambda_P = zeros(size(ratings));
counts_lambda_P = zeros(size(ratings));
lambda_P_all = cell(size(ratings));

% Determine relevant date range
start_pos = find(CDX.dates{1} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{1} <= end_date_num, 1, 'last');
used_range = start_pos:end_pos;

% Extract spread of index members at each point in time
used_cds = find(sum(CDX.index_members(used_range,:))>0);
for i=1:length(used_cds)
    % Extract ratings and spreads for requested time period
    cds = CDX.portfolio(used_cds(i));
    start_pos2 = find(cds.dates{1} >= start_date_num, 1, 'first');
    end_pos2 = find(cds.dates{1} <= end_date_num, 1, 'last');
    used_dates = cds.dates{1}(start_pos2:end_pos2);
    spread_5yr = cds.market_price{1}(start_pos2:end_pos2);
    cds_rating = cds.rating(start_pos2:end_pos2);
    if (isfield(cds, 'intensity_P')) & (length(cds.intensity_P)>0)
        intensity_P = cds.intensity_P(start_pos2:end_pos2);
        if (mean(intensity_P) > 0.02)
            test=1;
        end
    end

    % Extract 1-yaer spread and match dates
    start_pos3 = find(cds.dates{4} >= start_date_num, 1, 'first');
    end_pos3 = find(cds.dates{4} <= end_date_num, 1, 'last');
    used_dates_1yr = cds.dates{4}(start_pos3:end_pos3);
    spread_1yr = cds.market_price{4}(start_pos3:end_pos3);
    [trash, pos_5yr] = intersect_sorted(used_dates, used_dates_1yr);
    
    % Assign data into matching buckets
    for j=1:length(ratings)
        % 5-year Spreads
        counts(j) = counts(j) + sum(cds_rating == j);
        sum_spreads(j) = sum_spreads(j) + sum(spread_5yr(cds_rating == j));
        
        % 1-year Spreads
        counts_1yr(j) = counts_1yr(j) + sum(cds_rating(pos_5yr) == j);
        tmp = cds_rating(pos_5yr);
        sum_spreads_1yr(j) = sum_spreads_1yr(j) + sum(spread_1yr(tmp == j));
        
        % Lambda_P
        if isfield(cds, 'intensity_P')
            counts_lambda_P(j) = counts_lambda_P(j) + sum(cds_rating == j);
            sum_lambda_P(j) = sum_lambda_P(j) + sum(intensity_P(cds_rating == j));
            lambda_P_all{j} = [lambda_P_all{j}; intensity_P(cds_rating == j)];
        end
    end
end
avg_spread = sum_spreads ./ max(counts, 1);
avg_spread = round(avg_spread*10)/10;
avg_spread_1yr = sum_spreads_1yr ./ max(counts_1yr, 1);
avg_spread_1yr = round(avg_spread_1yr*10)/10;
avg_lambda_P = sum_lambda_P ./ counts_lambda_P;
med_lambda_P = [];
for i=1:length(lambda_P_all)
    med_lambda_P(i) = median(lambda_P_all{i});
end

% Put everything together into a table and write into Excel file
xlswrite('c:/thesis/main paper/implementation/tables/table1.xls', {'Rating' 'Counts' '1yr Default Probability' '5yr Default Probability' ...
                        '1yr CDS Spread' '5yr CDS Spread' 'Average lambda_P' 'Median lambda_P'}, 1, 'A1');
xlswrite('c:/thesis/main paper/implementation/tables/table1.xls', ratings', 1, 'A2');
xlswrite('c:/thesis/main paper/implementation/tables/table1.xls', counts', 1, 'B2');
xlswrite('c:/thesis/main paper/implementation/tables/table1.xls', moodys_1yr_default_rates', 1, 'C2');
xlswrite('c:/thesis/main paper/implementation/tables/table1.xls', moodys_5yr_default_rates', 1, 'D2');
xlswrite('c:/thesis/main paper/implementation/tables/table1.xls', avg_spread_1yr', 1, 'E2');
xlswrite('c:/thesis/main paper/implementation/tables/table1.xls', avg_spread', 1, 'F2');
xlswrite('c:/thesis/main paper/implementation/tables/table1.xls', avg_lambda_P'*1e4, 1, 'G2');
xlswrite('c:/thesis/main paper/implementation/tables/table1.xls', med_lambda_P'*1e4, 1, 'H2');

