function table3(CDX, start_date_num, end_date_num)
% --------------------------------------------------------------------------------------------------
% Creat a summary table ratings for CDS spread changes ...
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure which this CDX is part of (because need y0 & dynamics of common factor)
% start_date_num    ... optional datenum of start date, default: use all dates
% end_date_num      ... optional datenum of end date, default: use all dates
% --------------------------------------------------------------------------------------------------
% sample call: table3(CDX_NA_IG2)
% --------------------------------------------------------------------------------------------------

% Set default parameter values
if (nargin <= 1)
    start_date_num = CDX.dates{1}(1);
    end_date_num = CDX.dates{1}(end);
end

% Allocate memory
maturities = {'1 year' '5 years' '7 years' '10 years'};
changes_mean = zeros(size(maturities));
changes_median = zeros(size(maturities));
changes_std = zeros(size(maturities));
changes_min = zeros(size(maturities));;
changes_5_percentile = zeros(size(maturities));
changes_95_percentile = zeros(size(maturities));
changes_max = zeros(size(maturities));
changes = {[] [] [] []};

% Determine relevant date range
start_pos = find(CDX.dates{1} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{1} <= end_date_num, 1, 'last');
used_range = start_pos:end_pos;
num_dates = length(CDX.dates{1});

% Calculate statistics of spread for each tranche
for i=1:length(CDX.portfolio)
    % Determine relevant date range
    cds = CDX.portfolio(i);
    tmp = zeros(num_dates, 1);
    tmp(used_range) = 1;
    used_pos = logical((CDX.index_members(:,i) == 1) .* tmp);
    used_dates = CDX.dates{1}(used_pos);
    
	% Extract prices
    used_pos_1yr = ismember(cds.dates{4}, used_dates);
    used_pos_5yr = ismember(cds.dates{1}, used_dates);
    used_pos_7yr = ismember(cds.dates{2}, used_dates);
    used_pos_10yr = ismember(cds.dates{3}, used_dates);    
    price_1yr = cds.market_price{4}(used_pos_1yr);
    price_5yr = cds.market_price{1}(used_pos_5yr);
    price_7yr = cds.market_price{2}(used_pos_7yr);
    price_10yr = cds.market_price{3}(used_pos_10yr);
    
    % Add relative price changes
    if (length(price_1yr) > 1)
        changes{1} = [changes{1}; diff(price_1yr) ./ price_1yr(1:end-1)];
    end
    if (length(price_5yr) > 1)
        changes{2} = [changes{2}; diff(price_5yr) ./ price_5yr(1:end-1,:)];
    end
    if (length(price_7yr) > 1)
        changes{3} = [changes{3}; diff(price_7yr) ./ price_7yr(1:end-1)];
    end
    if (length(price_10yr) > 1)
        changes{4} = [changes{4}; diff(price_10yr) ./ price_10yr(1:end-1)];
    end
end

for i=1:length(changes)
    % Calculate statistics
    changes_mean(i) = mean(changes{i});
    changes_median(i) = median(changes{i});    
    changes_std(i) = std(changes{i});
    changes_min(i) = min(changes{i});
    changes_5_percentile(i) = prctile(changes{i}, 5);
    changes_95_percentile(i) = prctile(changes{i}, 95);
    changes_max(i) = max(changes{i});
end

% Put everything together into a table and write into Excel file
xlswrite('c:/thesis/main paper/implementation/tables/table3.xls', {'Maturity' 'Mean' 'Median' 'Standard Deviation' 'Min' '5th Percentile' '95th Percentile' 'Max'}, 1, 'A1');
xlswrite('c:/thesis/main paper/implementation/tables/table3.xls', maturities', 1, 'A2');
xlswrite('c:/thesis/main paper/implementation/tables/table3.xls', round(changes_mean'*1e4)/1e4, 1, 'B2');
xlswrite('c:/thesis/main paper/implementation/tables/table3.xls', round(changes_median'*1e4)/1e4, 1, 'C2');
xlswrite('c:/thesis/main paper/implementation/tables/table3.xls', round(changes_std'*1e4)/1e4, 1, 'D2');
xlswrite('c:/thesis/main paper/implementation/tables/table3.xls', round(changes_min'*1e4)/1e4, 1, 'E2');
xlswrite('c:/thesis/main paper/implementation/tables/table3.xls', round(changes_5_percentile'*1e4)/1e4, 1, 'F2');
xlswrite('c:/thesis/main paper/implementation/tables/table3.xls', round(changes_95_percentile'*1e4)/1e4, 1, 'G2');
xlswrite('c:/thesis/main paper/implementation/tables/table3.xls', round(changes_max'*1e4)/1e4, 1, 'H2');

