function table4(CDX, dates)
% --------------------------------------------------------------------------------------------------
% Creat a table with fitted parameter time series (row=dates, columns=parameters)
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% dates             ... for which dates to extract parameters
% --------------------------------------------------------------------------------------------------
% sample call: table4(cdx_tv_monthly, cdx_tv_monthly.dates{1}(1:3:end))
% --------------------------------------------------------------------------------------------------

% Determine relevant date range
used_pos = find(logical(is_member_sorted_c(CDX.dates{1}, dates)));
used_dates = {};
for i=1:length(dates)
    used_dates{i,1} = datestr(dates(i), 23);
end

% Generate table
x0 = get_x0(CDX, dates, 'mu*L', 'thet*k');
parameters = [x0{1} x0{2}*1e4 x0{3} x0{4} x0{5}*1e4 x0{6} x0{7} CDX.AJD_common_factor.L(used_pos,1)*1e4];

% Put everything together into a table and write into Excel file
xlswrite('c:/thesis/main paper/implementation/tables/table4.xls', {'Date' 'x0{1}' 'x0{2}' 'x0{3}' 'x0{4}' 'x0{5}' 'x0{6}' 'x0{7}', 'l_Y'}, 1, 'A1');
xlswrite('c:/thesis/main paper/implementation/tables/table4.xls', used_dates, 1, 'A2');
xlswrite('c:/thesis/main paper/implementation/tables/table4.xls', parameters, 1, 'B2');
