function y_prime = common_factor_ode(t, y, u, ajd_dynamics)
% --------------------------------------------------------------------------------------------------
% Returns the RHS of the ODE [A_re' A_img' B_re' B_img]' = ..., where the solution of the ODE is the
% Fourier transform of an integrated affine jump diffusion. See (A-2) in Mortensen (2006).
% --------------------------------------------------------------------------------------------------
% t             ... current time
% y             ... current value of function
% u             ... value at which transform should be evaluated
% ajd_dynamics  ... parameter vector with AJD dynamics
% --------------------------------------------------------------------------------------------------
% sample call: common_factor_ode(0, [0.01; 0.01; 0.01; 0.01])
% --------------------------------------------------------------------------------------------------

% Extract parameters
k     = ajd_dynamics.k;
theta = ajd_dynamics.theta;
sigma = ajd_dynamics.sigma;
L     = ajd_dynamics.L;
mu    = ajd_dynamics.mu;

% Calculate LHS of ODE
A_re_prime = -k*theta*y(3) - L*mu* (y(3)-mu*y(3)^2-mu*y(4)^2) / ((1-mu*y(3))^2 + mu^2*y(4)^2);
A_img_prime = -k*theta*y(4) - L*mu*y(4) / ((1-mu*y(3))^2 + mu^2*y(4)^2);
B_re_prime = k*y(3) - sigma^2/2 * (y(3)^2 - y(4)^2);
B_img_prime = k*y(4) - sigma^2*y(3)*y(4) - u;
y_prime = [A_re_prime A_img_prime B_re_prime B_img_prime]';