function y_prime = common_factor_ode2(t, y, q, ajd_dynamics)
% --------------------------------------------------------------------------------------------------
% ODE for common factor given from Eckner(2007), Appendix A.1
% --------------------------------------------------------------------------------------------------
% t             ... current time
% y             ... current value of function
% q             ... value at which transform should be evaluated
% ajd_dynamics  ... parameter vector with AJD dynamics
% --------------------------------------------------------------------------------------------------
% sample call: common_factor_ode2([0.01 0.01], -1, cdx_mor.AJD_common_factor)
% --------------------------------------------------------------------------------------------------

% Extract parameters
k     = ajd_dynamics.k;
theta = ajd_dynamics.theta;
sigma = ajd_dynamics.sigma;
L     = ajd_dynamics.L;
mu    = ajd_dynamics.mu;

% Calculate LHS of ODE
A_prime = -k*theta*y(2) - L*mu*y(2)/(1-mu*y(2));
B_prime = k*y(2) - 0.5*sigma^2*y(2)^2 - q;
y_prime = [A_prime; B_prime];