function rel_errors = density_integrated_ajd2_check_accuracy(x0, k, theta, sigma, L, mu, T, grid_N, method)
% --------------------------------------------------------------------------------------------------
% Check accuracy of funciton that calculates the density of an integrated affine jump diffusion.
% --------------------------------------------------------------------------------------------------
% x0                        ... initial intensity of AJD
% [k, theta, sigma, L, mu]  ... parameters of AJD dynamics
% T                         ... time horizons
% grid_N                    ... number of points for numerical integration of transform
% method                    ... by which method to calculate the Fourier transform
%                               0 ... Matlab implementation
%                               1 ... C implementation
%                               2 ... C implementation combined with spline interpolation (default)
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    density_integrated_ajd2_check_accuracy(0.01, 0.25, 0.02, 0.05, 0.02, 0.05, 5, 1000:1000:10000)
    density_integrated_ajd2_check_accuracy(0.01, 0.25, 0.02, 0.05, 0.02, 0.05, 5, 1000:1000:10000)
%}
% --------------------------------------------------------------------------------------------------

if (nargin <= 8)
    method = 2;
end

% Calculate relative error in survival probabilities
num_points = length(grid_N);
rel_errors = zeros(num_points, 1);
for n=1:num_points
    [density, dz] = density_integrated_ajd2_adaptive(x0, k, theta, sigma, L, mu, T, grid_N(n), method, 0);
    def_prob = 1 - sum(exp(-(0:(length(density)-1)) * dz) .* density) * dz;
    surv_prob2 = surv_prob_c5(x0, k, theta, sigma, L, mu, T, 0);
    def_prob2 = 1 - surv_prob2(end);
    rel_errors(n) = (def_prob - def_prob2) / def_prob2;
end

% Make nice plot
plot(grid_N, rel_errors);
xlabel('Number of grid points')
ylabel('Relative error')