% Command line arguments in /toolbox/distcomp/bin ... for job manager
% > mdce install
% > mdce start
% > startjobmanager
% > startworker -jobmanager default_jobmanager -jobmanagerhost abc321 (or abc101 for xlhost server)

% Command line arguments /toolbox/distcomp/bin ... for worker)
% > startworker -jobmanagerhost Andreas

% Matlab commands: running a job
jm = findResource('scheduler','type','jobmanager');
j = createJob(jm);
createTask(j, @sum, 1, {[1 1]});
createTask(j, @sum, 1, {[2 2]});
createTask(j, @sum, 1, {[3 3]});
submit(j);
waitForState(j);
results = getAllOutputArguments(j);
destroy(j)

% Evaluating a basic function
results = dfeval(@sum, {[1 1] [2 2] [3 3]});