function mgf_comparison(q)
% --------------------------------------------------------------------------------------------------
% Compare two different implementations for calculating the moment generating function of an
% integrated basic affine jump diffusion.
% --------------------------------------------------------------------------------------------------
% Method 1: Solve ODEs from Eckner(2007), Appendix A.1
% Method 2: Use explicit formula from Appendix A in "Credit Risk" by Duffie and Singleton (2003)
% --------------------------------------------------------------------------------------------------
% q     ... value at which evaluate MGF
% --------------------------------------------------------------------------------------------------
% sample call: mgf_comparison(-1)
% --------------------------------------------------------------------------------------------------

% Set typical AJD parameters
x0 = 0.002;
k = 0.25;
theta = 0.07;
sigma = 0.05;
L = 0.01;
mu = 0.15;
T = 5;
ajd_dynamics = struct('k', k, 'theta', theta, 'sigma', sigma, 'L', L, 'mu', mu);

% ODE based method
[trash, Y] = ode45(@common_factor_ode2, -(0:(1/250):T), zeros(2,1), odeset(), q, ajd_dynamics);
transform1 = exp(Y(end,1)+Y(end,2)*x0);

% Explicit method
transform2 = mgf_intAJD_c(x0, k, theta, sigma, L, mu, T, q);
transform2 = transform2(end);

% Calculate relative errors
err_real = (transform2 - transform1) ./ transform1;
disp(['Relative error: ' num2str(err_real)]);


