function port_loss_dist_comparions(CDX, N, date)
% --------------------------------------------------------------------------------------------------
% Compare the porfolio loss distribution implied by different LGD dynamics: fixed, stocastic,
% stochastic and serially correlated
% --------------------------------------------------------------------------------------------------
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% N                             ... number of points for numerical integration of Fourier transform
% date                          ... date for which to do comparison
% maturities                    ... which maturities to update (indicator vector), default: update
% all
% --------------------------------------------------------------------------------------------------
% sample call: port_loss_dist_comparions(cdx_mor, 10000, datenum('12/05/2005'))
% --------------------------------------------------------------------------------------------------

% Determine maximum needed horizon
used_range = find(CDX.dates{1} == date);

% Calculate distribution of number of defaults
num_def_dist = port_loss_dist_interpolate(date, [0 1 5], CDX.portfolio, CDX.index_members(used_range,:), CDX.y0(used_range), ...
                                       CDX.AJD_common_factor, N, 1, CDX.liq_prem_tranches(used_range));
num_def_dist = squeeze(num_def_dist(1,end,:));                                 
num_firms = length(num_def_dist)-1;

% Deterministic LGD
loss_dist1 = num_def_dist/CDX.LGD.mean;
scale1 = (0:num_firms)*CDX.LGD.mean/num_firms*100;

% Stochastic LGD


% Stochastic and serially correlated LGD
G_n2 = G_n_LGD_Markov(num_firms, repmat(2/3, num_firms, 1));
%G_n2 = G_n_LGD_Markov(num_firms, max(1/2-(1:num_firms)/num_firms*0.2, 0));
loss_dist3 = zeros(1, (num_firms*3+1));
for n=1:(num_firms+1)
    loss_dist3(n:(n*3-2)) = loss_dist3(n:(n*3-2)) + G_n2{n}*num_def_dist(n);
end
loss_dist3 = loss_dist3/0.3;
scale3 = (0:(num_firms*3)) * 0.3 / num_firms * 100;

% Make plot
semilogy(scale1, loss_dist1);
hold on
semilogy(scale3, loss_dist3, 'Color', 'Red');
hold off
%axis([0 30 1e-5 0.3])
axis([0 15 4e-4 0.3])