function port_loss_interpolation_comparions(CDX, N, date, spacings)
% --------------------------------------------------------------------------------------------------
% Compare the porfolio loss distribution P_t for different spacing in the interpolation. The object
% of comparison is P_t for t=T-spacing/2.
% --------------------------------------------------------------------------------------------------
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% N                             ... number of points for numerical integration of Fourier transform
% date                          ... date for which to do comparison
% spacings                      ... spacgins to evaluate (measured in quarters)
% --------------------------------------------------------------------------------------------------
% sample call: port_loss_interpolation_comparions(cdx_mor, 100000, datenum('12/05/2005'), [1 2 4 8])
% --------------------------------------------------------------------------------------------------

% Determine maximum needed horizon
used_range = find(CDX.dates{1} == date);

% Calculate distribution of number of defaults
for i=1:length(spacings)
    % Calculate interpolated portfolio loss distribution
    used_horizons = (CDX.T{1} - floor(CDX.T{1})):0.25:CDX.T{1};
    num_def_dist = port_loss_dist_interpolate(date, used_horizons, CDX.portfolio, CDX.index_members(used_range,:), CDX.y0(used_range), ...
                                              CDX.AJD_common_factor, N, spacings(i), CDX.liq_prem_tranches(used_range));                                  
    num_def_dist = squeeze(num_def_dist(1,:,:));    
    
    % Store true distribution
    if (i==1)
        true_loss_dist = num_def_dist;
    end
    
    % Compare interpolated with true loss dist
    if (i > 1)
        pos = length(used_horizons) - spacings(i)/2;
        true_dist = true_loss_dist(pos,:);
        interp_dist = num_def_dist(pos,:);
        plot(interp_dist-true_dist);
    end
end