function [tail, threshold] = test_poisson_tail(values)
% sample call:  [tail, threshold] = test_poisson_tail(1:50)
%               [tail, threshold] = test_poisson_tail(0.1:0.1:1)
% 

tail = [];
threshold = [];
for i=1:length(values)
    lambda = values(i);
    K = round(8 + lambda + 8*sqrt(lambda));
    threshold = [threshold; K];
    tail = [tail; 1-poisscdf(K,lambda)];
end    