function [transform, horizons] = transform_integrated_ajd(u, x0, ajd_dynamics, horizons)
% --------------------------------------------------------------------------------------------------
% Calculate the transform of an integrated affine-jump-diffusion, i.e. E(exp(i*u*int_0^T(x_t dt)))
% --------------------------------------------------------------------------------------------------
% u             ... value at which transform should be evaluated
% x0            ... initial intensity of AJD
% ajd_dynamics  ... parameter vector with AJD dynamics
% horizons      ... vector of time horizon for which to compute the transfrom
% --------------------------------------------------------------------------------------------------
% sample call: transform_integrated_ajd(1, 0.01, struct('k',0.2,'theta',0.02,'sigma',0.01,'L',0.2,'mu',0.03), 0:0.25:5)
%
% new fast version: [t_real, t_imag] = transform2_integrated_ajd_c(0, 1, 0.01, 0.2, 0.02, 0.01, 0.2, 0.03, 5)
% --------------------------------------------------------------------------------------------------

% Solve ODE for exponentially affine representation of transform
[T, Y] = ode45(@common_factor_ode, -horizons, zeros(4,1), odeset(), u, ajd_dynamics);

% Calculate transfrom from the ODE solution
A = Y(:,1)+i*Y(:,2);
B = Y(:,3)+i*Y(:,4);
transform = exp(A+B*x0);